/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AxisLogE;
import info.monitorenter.gui.chart.errorbars.ErrorBarPainter;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyAbsoluteSummation;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ZoomChartWithErrorBarsAndLogAxis
extends JFrame {
    public static void main(String[] args) {
        ZoomChartWithErrorBarsAndLogAxis zoomTest = new ZoomChartWithErrorBarsAndLogAxis();
        zoomTest.setSize(640, 480);
        zoomTest.setVisible(true);
    }

    public ZoomChartWithErrorBarsAndLogAxis() {
        super("ZoomableChart with log y axis and errorbars");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        ZoomableChart chart = new ZoomableChart();
        Trace2DSimple trace = new Trace2DSimple("Trace");
        trace.setColor(Color.BLUE);
        ErrorBarPolicyAbsoluteSummation errorBarPolicy = new ErrorBarPolicyAbsoluteSummation(4.0, 4.0);
        errorBarPolicy.setShowPositiveYErrors(true);
        ErrorBarPainter painter = new ErrorBarPainter();
        errorBarPolicy.addErrorBarPainter(painter);
        trace.addErrorBarPolicy(errorBarPolicy);
        chart.addTrace(trace);
        chart.setAxisYLeft(new AxisLogE());
        for (int i = 1; i < 100; ++i) {
            trace.addPoint(i, i);
        }
        c.add(new ChartPanel(chart));
        JButton zoomAllButton = new JButton("Zoom All");
        zoomAllButton.addActionListener(new ZoomAllAdapter(chart));
        c.add((Component)zoomAllButton, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    class ZoomAllAdapter
    implements ActionListener {
        private ZoomableChart m_zoomableChart;

        public ZoomAllAdapter(ZoomableChart chart) {
            this.m_zoomableChart = chart;
        }

        public void actionPerformed(ActionEvent event) {
            this.m_zoomableChart.zoomAll();
        }
    }
}

