/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.pointhighlighters.PointHighlighterConfigurable;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ZoomTest
extends JFrame {
    public static void main(String[] args) {
        ZoomTest zoomTest = new ZoomTest();
        zoomTest.setSize(640, 480);
        zoomTest.setVisible(true);
    }

    public ZoomTest() {
        super("ZoomTest");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        ZoomableChart chart = new ZoomableChart();
        Trace2DSimple trace = new Trace2DSimple("Trace");
        chart.addTrace(trace);
        trace.setColor(Color.RED);
        trace.setStroke(new BasicStroke(2.0f));
        trace.addPoint(0.0, 0.0);
        trace.addPoint(1.0, 1.0);
        trace.addPoint(2.0, 1.0);
        trace.addPoint(3.0, 2.0);
        trace.addPoint(4.0, 1.0);
        trace.addPoint(5.0, 0.0);
        trace = new Trace2DSimple();
        chart.addTrace(trace);
        trace.addPoint(0.0, 3.0);
        trace.addPoint(1.0, 2.0);
        trace.addPoint(2.0, 2.0);
        trace.addPoint(3.0, 0.0);
        trace.addPoint(4.0, -1.0);
        trace.addPoint(5.0, 1.0);
        trace.setColor(Color.BLUE);
        chart.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        trace.setPointHighlighter(new PointHighlighterConfigurable(new PointPainterDisc(10), true));
        chart.enablePointHighlighting(true);
        c.add(new ChartPanel(chart));
        JButton zoomAllButton = new JButton("Zoom All");
        zoomAllButton.addActionListener(new ZoomAllAdapter(chart));
        c.add((Component)zoomAllButton, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    class ZoomAllAdapter
    implements ActionListener {
        private ZoomableChart m_zoomableChart;

        public ZoomAllAdapter(ZoomableChart chart) {
            this.m_zoomableChart = chart;
        }

        public void actionPerformed(ActionEvent event) {
            this.m_zoomableChart.zoomAll();
        }
    }
}

