/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPixel;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

public class ErrorBarPainter
implements IErrorBarPainter {
    private Color m_connectionColor;
    private IPointPainter m_connectionPainter;
    private Color m_endPointColor;
    private IPointPainter m_endPointPainter;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final IErrorBarPainter.ISegment m_segmentConnection = new ASegment(){

        public Color getColor() {
            return ErrorBarPainter.this.getConnectionColor();
        }

        public String getName() {
            return "Connection segment";
        }

        public IPointPainter getPointPainter() {
            return ErrorBarPainter.this.getConnectionPainter();
        }

        public final String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_CONNECTION_COLOR";
        }

        public final String getPropertySegmentPointPainter() {
            return "IErrorBarPainter.PROPERTY_CONNECTION";
        }

        public void setColor(Color color) {
            ErrorBarPainter.this.setConnectionColor(color);
        }

        public void setPointPainter(IPointPainter pointPainter) {
            ErrorBarPainter.this.setConnectionPainter(pointPainter);
        }
    };
    private final IErrorBarPainter.ISegment m_segmentEnd = new ASegment(){

        public Color getColor() {
            return ErrorBarPainter.this.getEndPointColor();
        }

        public String getName() {
            return "End segment";
        }

        public IPointPainter getPointPainter() {
            return ErrorBarPainter.this.getEndPointPainter();
        }

        public String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_ENDPOINT_COLOR";
        }

        public String getPropertySegmentPointPainter() {
            return "IErrorBarPainter.PROPERTY_CONNECTION_COLOR";
        }

        public void setColor(Color color) {
            ErrorBarPainter.this.setEndPointColor(color);
        }

        public void setPointPainter(IPointPainter pointPainter) {
            ErrorBarPainter.this.setEndPointPainter(pointPainter);
        }
    };
    private final IErrorBarPainter.ISegment m_segmentStart = new ASegment(){

        public Color getColor() {
            return ErrorBarPainter.this.getStartPointColor();
        }

        public String getName() {
            return "Start segment";
        }

        public IPointPainter getPointPainter() {
            return ErrorBarPainter.this.getStartPointPainter();
        }

        public String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_STARTPOINT_COLOR";
        }

        public String getPropertySegmentPointPainter() {
            return "IErrorBarPainter.PROPERTY_STARTPOINT";
        }

        public void setColor(Color color) {
            ErrorBarPainter.this.setStartPointColor(color);
        }

        public void setPointPainter(IPointPainter pointPainter) {
            ErrorBarPainter.this.setStartPointPainter(pointPainter);
        }
    };
    private Color m_startPointColor = Color.GRAY;
    private IPointPainter m_startPointPainter = null;

    public ErrorBarPainter() {
        this.m_connectionColor = Color.GRAY;
        this.m_connectionPainter = new PointPainterLine();
        this.m_endPointColor = Color.GRAY;
        this.m_endPointPainter = new PointPainterDisc(4);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public final Color getConnectionColor() {
        return this.m_connectionColor;
    }

    public final IPointPainter getConnectionPainter() {
        return this.m_connectionPainter;
    }

    public final Color getEndPointColor() {
        return this.m_endPointColor;
    }

    public final IPointPainter getEndPointPainter() {
        return this.m_endPointPainter;
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(property);
    }

    public IErrorBarPainter.ISegment getSegmentConnection() {
        return this.m_segmentConnection;
    }

    public IErrorBarPainter.ISegment getSegmentEnd() {
        return this.m_segmentEnd;
    }

    public IErrorBarPainter.ISegment getSegmentStart() {
        return this.m_segmentStart;
    }

    public final Color getStartPointColor() {
        return this.m_startPointColor;
    }

    public final IPointPainter getStartPointPainter() {
        return this.m_startPointPainter;
    }

    public void paintErrorBar(int absoluteX, int absoluteY, Graphics g, IErrorBarPixel errorBar) {
        int x2;
        int y2;
        Chart2D chart = errorBar.getTrace().getRenderer();
        int xStart = chart.getXChartStart();
        int xEnd = chart.getXChartEnd();
        int yStart = chart.getYChartStart();
        int yEnd = chart.getYChartEnd();
        int x1 = absoluteX < xStart ? xStart : absoluteX;
        x1 = absoluteX > xEnd ? xEnd : absoluteX;
        int y1 = absoluteY > yStart ? yStart : absoluteY;
        y1 = absoluteY < yEnd ? yEnd : absoluteY;
        int error = errorBar.getNegativeXErrorPixel();
        if (error != Integer.MAX_VALUE) {
            y2 = y1;
            x2 = error < xStart ? xStart : error;
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_connectionPainter, this.m_connectionColor, g);
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_startPointPainter, this.m_startPointColor, g);
            if (x2 == error) {
                this.paintErrorBarPart(x2, y1, x1, y1, this.m_endPointPainter, this.m_endPointColor, g);
            }
        }
        if ((error = errorBar.getPositiveXErrorPixel()) != Integer.MAX_VALUE) {
            y2 = y1;
            x2 = error > xEnd ? xEnd : error;
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_connectionPainter, this.m_connectionColor, g);
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_startPointPainter, this.m_startPointColor, g);
            if (x2 == error) {
                this.paintErrorBarPart(x2, y1, x1, y1, this.m_endPointPainter, this.m_endPointColor, g);
            }
        }
        if ((error = errorBar.getNegativeYErrorPixel()) != Integer.MAX_VALUE) {
            x2 = x1;
            y2 = error > yStart ? yStart : error;
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_connectionPainter, this.m_connectionColor, g);
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_startPointPainter, this.m_startPointColor, g);
            if (y2 == error) {
                this.paintErrorBarPart(x1, y2, x1, y1, this.m_endPointPainter, this.m_endPointColor, g);
            }
        }
        if ((error = errorBar.getPositiveYErrorPixel()) != Integer.MAX_VALUE) {
            x2 = x1;
            y2 = error < yEnd ? yEnd : error;
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_connectionPainter, this.m_connectionColor, g);
            this.paintErrorBarPart(x1, y1, x2, y2, this.m_startPointPainter, this.m_startPointColor, g);
            if (y2 == error) {
                this.paintErrorBarPart(x1, y2, x1, y1, this.m_endPointPainter, this.m_endPointColor, g);
            }
        }
    }

    private final void paintErrorBarPart(int absoluteX, int absoluteY, int nextX, int nextY, IPointPainter pointPainter, Color color, Graphics g2d) {
        if (pointPainter != null) {
            boolean colorChange = false;
            Color backupColor = g2d.getColor();
            if (color != null) {
                colorChange = true;
                g2d.setColor(color);
            }
            pointPainter.paintPoint(absoluteX, absoluteY, nextX, nextY, g2d, null);
            if (colorChange) {
                g2d.setColor(backupColor);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    public final void setConnectionColor(Color connectionColor) {
        Color old = this.m_connectionColor;
        this.m_connectionColor = connectionColor;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", old, this.m_connectionColor);
    }

    public final void setConnectionPainter(IPointPainter connectionPainter) {
        IPointPainter old = this.m_connectionPainter;
        this.m_connectionPainter = connectionPainter;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION", old, connectionPainter);
    }

    public final void setEndPointColor(Color endPointColor) {
        Color old = this.m_endPointColor;
        this.m_endPointColor = endPointColor;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", old, this.m_endPointColor);
    }

    public final void setEndPointPainter(IPointPainter endPointPainter) {
        IPointPainter old = this.m_endPointPainter;
        this.m_endPointPainter = endPointPainter;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", old, endPointPainter);
    }

    public final void setStartPointColor(Color startPointColor) {
        Color old = this.m_startPointColor;
        this.m_startPointColor = startPointColor;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", old, this.m_startPointColor);
    }

    public final void setStartPointPainter(IPointPainter startPointPainter) {
        IPointPainter old = this.m_startPointPainter;
        this.m_startPointPainter = startPointPainter;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_STARTPOINT", old, this.m_startPointPainter);
    }

    private abstract class ASegment
    implements IErrorBarPainter.ISegment {
        protected ASegment() {
        }

        public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
            ErrorBarPainter.this.addPropertyChangeListener(property, listener);
        }
    }
}

