/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.events.AChart2DAction;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

public final class Chart2DActionPrintSingleton
extends AChart2DAction {
    private static Map<String, Chart2DActionPrintSingleton> instances = new HashMap<String, Chart2DActionPrintSingleton>();
    private transient boolean m_printWholePage = false;

    public static Chart2DActionPrintSingleton getInstance(Chart2D chart) {
        Chart2DActionPrintSingleton result = instances.get(Chart2DActionPrintSingleton.key(chart));
        return result;
    }

    public static Chart2DActionPrintSingleton getInstance(Chart2D chart, String actionName) {
        Chart2DActionPrintSingleton result = Chart2DActionPrintSingleton.getInstance(chart);
        if (result == null) {
            result = new Chart2DActionPrintSingleton(chart, actionName);
            instances.put(Chart2DActionPrintSingleton.key(chart), result);
        }
        return result;
    }

    private static String key(Chart2D chart) {
        return chart.getClass().getName() + chart.hashCode();
    }

    private Chart2DActionPrintSingleton(Chart2D chart, String colorName) {
        super(chart, colorName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.m_chart);
        boolean ok = job.printDialog();
        if (ok) {
            this.m_printWholePage = true;
            try {
                job.print();
            }
            catch (PrinterException ex) {
            }
            finally {
                this.m_printWholePage = false;
                this.m_chart.resetPrintMode();
            }
        }
    }

    public final boolean isPrintWholePage() {
        return this.m_printWholePage;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

