/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.util.MathUtil;
import java.io.Serializable;

public class Range
implements Serializable {
    public static final Range RANGE_UNBOUNDED = new Range(-1.7976931348623157E308, Double.MAX_VALUE);
    protected double m_max;
    protected double m_min;

    public Range(double min, double max) {
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("Cannot work on Double.NaN for min.");
        }
        MathUtil.assertDouble(min);
        MathUtil.assertDouble(max);
        if (min < max) {
            this.m_min = min;
            this.m_max = max;
        } else {
            this.m_min = max;
            this.m_max = min;
        }
    }

    public boolean equals(Object obj) {
        boolean result = true;
        if (obj instanceof Range) {
            Range other = (Range)obj;
            result = this.m_max == other.m_max && this.m_min == other.m_min;
        } else {
            result = false;
        }
        return result;
    }

    public double getExtent() {
        return this.m_max - this.m_min;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getMin() {
        return this.m_min;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isContained(double contained) {
        return this.m_min <= contained && this.m_max >= contained;
    }

    public void mimic(Range r) {
        this.m_max = r.m_max;
        this.m_min = r.m_min;
    }

    public final void setMax(double max) {
        this.m_max = max;
    }

    public final void setMin(double min) {
        this.m_min = min;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("Range[");
        ret.append(this.m_min).append(',');
        ret.append(this.m_max).append(']');
        return ret.toString();
    }
}

