/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.IPointHighlighter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracePoint2D
extends Point2D.Double
implements ITracePoint2D {
    private ITrace2D m_listener;
    private Set<IPointHighlighter<?>> m_additionalPointHighlighters = new LinkedHashSet();
    private double m_scaledX;
    private double m_scaledY;
    private double m_x;
    private double m_y;

    protected TracePoint2D() {
    }

    public TracePoint2D(double xValue, double yValue) {
        this.m_x = xValue;
        this.m_y = yValue;
    }

    @Override
    public final boolean addAdditionalPointHighlighter(IPointHighlighter<?> additionalPointPainter) {
        boolean result = this.m_additionalPointHighlighters.add(additionalPointPainter);
        return result;
    }

    @Override
    public Object clone() {
        TracePoint2D result = (TracePoint2D)super.clone();
        result.m_x = this.m_x;
        result.m_y = this.m_y;
        result.m_scaledX = this.m_scaledX;
        result.m_scaledY = this.m_scaledY;
        result.m_additionalPointHighlighters = new LinkedHashSet(this.m_additionalPointHighlighters);
        return result;
    }

    @Override
    public int compareTo(ITracePoint2D obj) {
        double othx = obj.getX();
        int result = this.m_x < othx ? -1 : (this.m_x == othx ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ITracePoint2D) {
            result = this.compareTo((ITracePoint2D)o) == 0;
        }
        return result;
    }

    @Override
    public final Set<IPointHighlighter<?>> getAdditionalPointHighlighters() {
        return this.m_additionalPointHighlighters;
    }

    @Override
    public ITrace2D getListener() {
        return this.m_listener;
    }

    @Override
    public double getManhattanDistance(double xNormalized, double yNormalized) {
        double result = Math.abs(this.m_scaledX - xNormalized) + Math.abs(this.m_scaledY - yNormalized);
        return result;
    }

    @Override
    public double getManhattanDistance(ITracePoint2D point) {
        return this.getManhattanDistance(point.getX(), point.getY());
    }

    @Override
    public final double getScaledX() {
        return this.m_scaledX;
    }

    @Override
    public final double getScaledY() {
        return this.m_scaledY;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void setListener(ITrace2D listener) {
        this.m_listener = listener;
    }

    @Override
    public void setLocation(double xValue, double yValue) {
        this.m_x = xValue;
        this.m_y = yValue;
        if (this.m_listener != null) {
            this.m_listener.firePointChanged(this, 4);
        }
    }

    @Override
    public final void setScaledX(double scaledX) {
        this.m_scaledX = scaledX;
    }

    @Override
    public final void setScaledY(double scaledY) {
        this.m_scaledY = scaledY;
    }

    @Override
    public String toString() {
        return "TracePoint2D[" + this.m_x + ", " + this.m_y + "]";
    }
}

