/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.painters;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

public class TracePainterFill
extends ATracePainter {
    private Chart2D m_chart;
    private List<Integer> m_xPoints;
    private List<Integer> m_yPoints;

    public TracePainterFill(Chart2D chart) {
        this.m_chart = chart;
    }

    public void discontinue(Graphics g2d) {
        this.endPaintIteration(g2d);
        this.startPaintIteration(g2d);
    }

    public void endPaintIteration(Graphics g2d) {
        if (g2d != null) {
            int[] x = new int[this.m_xPoints.size() + 4];
            x[0] = this.m_chart.getXChartStart();
            int count = 1;
            for (Integer xpoint : this.m_xPoints) {
                x[count] = xpoint;
                ++count;
            }
            x[count] = this.getPreviousX();
            x[count + 1] = x[count];
            x[count + 2] = this.m_chart.getXChartStart();
            int[] y = new int[this.m_yPoints.size() + 4];
            y[0] = this.m_chart.getYChartStart();
            count = 1;
            for (Integer ypoint : this.m_yPoints) {
                y[count] = ypoint;
                ++count;
            }
            y[count] = this.getPreviousY();
            y[count + 1] = this.m_chart.getYChartStart();
            y[count + 2] = this.m_chart.getYChartStart();
            g2d.fillPolygon(x, y, x.length);
        }
    }

    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        this.m_xPoints.add(absoluteX);
        this.m_yPoints.add(absoluteY);
        super.paintPoint(absoluteX, absoluteY, nextX, nextY, g, original);
    }

    public void startPaintIteration(Graphics g2d) {
        this.m_xPoints = new LinkedList<Integer>();
        this.m_yPoints = new LinkedList<Integer>();
    }
}

