/*
 * Decompiled with CFR 0.152.
 */
package dmrgvisu2;

import dmrgvisu2.Dmrg;
import dmrgvisu2.Matrix;
import dmrgvisu2.Op;
import dmrgvisu2.visu;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.io.ADataCollector;

public class DmrgCollector
extends ADataCollector {
    public Dmrg DmrgRef;
    public visu visuRef;
    public ITrace2D en;
    public ITrace2D dm;
    public ITrace2D erwsx;
    public ITrace2D erwsz;
    public ITrace2D ee;
    public int MaxSweeps;

    public DmrgCollector(ITrace2D iTrace2D, ITrace2D iTrace2D2, ITrace2D iTrace2D3, ITrace2D iTrace2D4, ITrace2D iTrace2D5, int n, long l) {
        super(iTrace2D, l);
        this.en = iTrace2D;
        this.dm = iTrace2D2;
        this.erwsx = iTrace2D3;
        this.erwsz = iTrace2D4;
        this.ee = iTrace2D5;
        this.MaxSweeps = n;
    }

    public void SetDmrg(Dmrg dmrg) {
        this.DmrgRef = dmrg;
    }

    public void SetVisu(visu visu2) {
        this.visuRef = visu2;
    }

    public TracePoint2D collectData() {
        if (this.DmrgRef.CurrentSweep == this.MaxSweeps) {
            this.visuRef.stopData();
        }
        int n = this.DmrgRef.DoNextStep();
        TracePoint2D tracePoint2D = new TracePoint2D((double)n, this.DmrgRef.CurrentEnergy);
        this.dm.removeAllPoints();
        for (int i = 0; i < this.DmrgRef.CurrentDm.length; ++i) {
            this.dm.addPoint((double)i, this.DmrgRef.CurrentDm[i]);
        }
        Matrix matrix = new Matrix(2, 2);
        Matrix matrix2 = new Matrix(2, 2);
        matrix.SetContent(0, 0, 0.5);
        matrix.SetContent(1, 1, -0.5);
        matrix2.SetContent(0, 1, 0.5);
        matrix2.SetContent(1, 0, 0.5);
        Op op = new Op(this.DmrgRef.state.N);
        op.SetLocalOp(n, matrix);
        Op op2 = new Op(this.DmrgRef.state.N);
        op2.SetLocalOp(n, matrix2);
        this.erwsz.addPoint((double)n, op.ScalarProd(this.DmrgRef.state, this.DmrgRef.state));
        this.erwsx.addPoint((double)n, op2.ScalarProd(this.DmrgRef.state, this.DmrgRef.state));
        double d = 0.0;
        for (int i = 0; i < this.DmrgRef.CurrentDm.length; ++i) {
            d += this.DmrgRef.CurrentDm[i] * (Math.log(this.DmrgRef.CurrentDm[i]) / Math.log(2.0));
        }
        this.ee.addPoint((double)n + 0.5 * (double)(!this.DmrgRef.Direction ? 1 : -1), -d);
        if (this.DmrgRef.CurrentEnergy < this.DmrgRef.MinEnergy) {
            this.DmrgRef.MinEnergy = this.DmrgRef.CurrentEnergy;
            this.DmrgRef.EnergyText.setText("Minimal energy: " + this.DmrgRef.MinEnergy);
        }
        this.DmrgRef.SweepText.setText("Current sweep: " + this.DmrgRef.CurrentSweep);
        this.DmrgRef.SiteText.setText("Current site: " + n);
        return tracePoint2D;
    }
}

