/*
 * Decompiled with CFR 0.152.
 */
package dmrgvisu2;

import dmrgvisu2.Matrix;
import dmrgvisu2.MatrixMatrix;
import dmrgvisu2.Mps;

public class Mpo {
    int N;
    Matrix[][][] W;
    int d;
    int d_max;
    int states;

    public Mpo() {
        System.out.println("DNU! MPO-Constructor");
        this.d = 1;
        this.N = 4;
        this.states = 2;
        this.W = new Matrix[this.N][this.states][this.states];
        for (int i = 0; i < this.N / 2; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    this.W[i][j][k] = new Matrix(this.d, this.d);
                    this.W[this.N - i - 1][j][k] = new Matrix(this.d, this.d);
                }
            }
        }
    }

    public Mpo(MatrixMatrix matrixMatrix, int n, int n2, int n3) {
        int n4;
        MatrixMatrix[] matrixMatrixArray = new MatrixMatrix[n];
        matrixMatrixArray[0] = new MatrixMatrix(matrixMatrix.GetSize()[1], 1);
        for (n4 = 0; n4 < matrixMatrix.GetSize()[1]; ++n4) {
            matrixMatrixArray[0].SetContent(n4, 0, matrixMatrix.GetContent(n4, matrixMatrix.GetSize()[1] - 1));
        }
        for (n4 = 1; n4 < n - 1; ++n4) {
            matrixMatrixArray[n4] = new MatrixMatrix(matrixMatrix);
        }
        matrixMatrixArray[n - 1] = new MatrixMatrix(1, matrixMatrix.GetSize()[0]);
        for (n4 = 0; n4 < matrixMatrix.GetSize()[0]; ++n4) {
            matrixMatrixArray[n - 1].SetContent(0, n4, matrixMatrix.GetContent(0, n4));
        }
        this.init(matrixMatrixArray, n, n2, n3);
    }

    private void init(MatrixMatrix[] matrixMatrixArray, int n, int n2, int n3) {
        this.d = n3;
        this.N = n;
        this.states = n2;
        this.W = new Matrix[this.N][this.states][this.states];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    this.W[i][j][k] = new Matrix(matrixMatrixArray[i].GetSize()[1], matrixMatrixArray[i].GetSize()[0]);
                    for (int i2 = 0; i2 < this.W[i][j][k].GetSize()[1]; ++i2) {
                        for (int i3 = 0; i3 < this.W[i][j][k].GetSize()[0]; ++i3) {
                            this.W[i][j][k].SetContent(i2, i3, matrixMatrixArray[i].GetContent(i2, i3).GetContent(j, k));
                        }
                    }
                }
            }
        }
    }

    public Mpo(MatrixMatrix[] matrixMatrixArray, int n, int n2, int n3) {
        this.init(matrixMatrixArray, n, n2, n3);
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    string = string + this.W[i][j][k];
                }
            }
        }
        return string;
    }

    public void printreadable() {
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    System.out.println("W[" + i + "][" + j + "][" + k + "]");
                    this.W[i][j][k].printreadable();
                }
            }
        }
    }

    public Mps mult(Mps mps) {
        Mps mps2 = new Mps(this.N, mps.d * this.W[0][0][0].GetSize()[1], mps.d_max * this.W[this.N / 2][0][0].GetSize()[1], this.states);
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    for (int i2 = 0; i2 < mps.A[i][j].GetSize()[0]; ++i2) {
                        for (int i3 = 0; i3 < mps.A[i][j].GetSize()[1]; ++i3) {
                            for (int i4 = 0; i4 < this.W[i][j][k].GetSize()[0]; ++i4) {
                                for (int i5 = 0; i5 < this.W[i][j][k].GetSize()[1]; ++i5) {
                                    mps2.A[i][j].SetContent(i5 * mps.A[i][j].GetSize()[1] + i3, i4 * mps.A[i][j].GetSize()[0] + i2, mps2.A[i][j].GetContent(i5 * mps.A[i][j].GetSize()[1] + i3, i4 * mps.A[i][j].GetSize()[0] + i2) + this.W[i][j][k].GetContent(i5, i4) * mps.A[i][k].GetContent(i3, i2));
                                }
                            }
                        }
                    }
                }
            }
        }
        return mps2;
    }
}

