/*
 * Decompiled with CFR 0.152.
 */
package dmrgvisu2;

import org.netlib.blas.DGEMM;
import org.netlib.lapack.DGESVD;
import org.netlib.lapack.DSYEV;
import org.netlib.util.intW;

public class Matrix {
    int[] Size;
    double[][] Content;
    int[] Merges;
    boolean[] MergesUnder;

    public int[] GetSize() {
        return this.Size;
    }

    public double[][] GetContent() {
        return this.Content;
    }

    public Matrix() {
        this.SetSize(1, 1);
        this.Merges = new int[0];
        this.MergesUnder = new boolean[0];
    }

    public Matrix(int[] nArray) {
        this.SetSize(nArray);
        this.Merges = new int[0];
        this.MergesUnder = new boolean[0];
    }

    public Matrix(int n, int n2) {
        this.SetSize(n, n2);
        this.Merges = new int[0];
        this.MergesUnder = new boolean[0];
    }

    public Matrix(Matrix matrix) {
        this.Size = matrix.GetSize();
        this.Content = matrix.GetContent();
        this.Merges = matrix.Merges;
        this.MergesUnder = matrix.MergesUnder;
    }

    private void CreateContent() {
        this.Content = new double[this.Size[0]][this.Size[1]];
        for (int i = 0; i < this.Size[0]; ++i) {
            for (int j = 0; j < this.Size[1]; ++j) {
                this.Content[i][j] = 0.0;
            }
        }
    }

    public void SetContent(int n, int n2, double d) {
        this.Content[n2][n] = d;
    }

    public double GetContent(int n, int n2) {
        return this.Content[n2][n];
    }

    public void SetContent(double[][] dArray) {
        this.SetSize(dArray[0].length, dArray.length);
        this.Content = dArray;
    }

    public void SetSize(int n, int n2) {
        int[] nArray = new int[]{n2, n};
        this.SetSize(nArray);
    }

    public void SetSize(int[] nArray) {
        this.Size = nArray;
        this.CreateContent();
    }

    public String toString() {
        int n;
        String string = "This Matrix has the size: " + this.Size[1] + " by " + this.Size[0];
        if (this.Merges.length != 0) {
            string = string + " and is merged on ";
            for (n = 0; n < this.Merges.length; ++n) {
                string = string + this.Merges[n] + "\n";
            }
        } else {
            string = string + "\n";
        }
        for (n = 0; n < this.Size[0]; ++n) {
            for (int i = 0; i < this.Size[1]; ++i) {
                string = string + " " + this.Content[n][i];
            }
            string = string + "\n";
        }
        return string;
    }

    public void printreadable() {
        int n;
        System.out.format("This Matrix has the size: %d by %d", this.Size[1], this.Size[0]);
        if (this.Merges.length != 0) {
            System.out.format(" and is merged on ", new Object[0]);
            for (n = 0; n < this.Merges.length; ++n) {
                System.out.format("%d %n", this.Merges[n]);
            }
        } else {
            System.out.format("%n", new Object[0]);
        }
        for (n = 0; n < this.Size[0]; ++n) {
            for (int i = 0; i < this.Size[1]; ++i) {
                System.out.format(" %12.3f", this.Content[n][i]);
            }
            System.out.format("%n", new Object[0]);
        }
    }

    public Matrix mult(Matrix matrix) {
        if (matrix.GetSize()[0] == 1 && matrix.GetSize()[1] == 1) {
            return this.mult(matrix.GetContent(0, 0));
        }
        if (this.GetSize()[0] == 1 && this.GetSize()[1] == 1) {
            return matrix.mult(this.GetContent(0, 0));
        }
        return this.mult(matrix, "n");
    }

    public Matrix mult(Matrix matrix, String string) {
        String string2 = "n";
        int n = string2 == "n" ? this.GetSize()[0] : this.GetSize()[1];
        int n2 = string == "n" ? matrix.GetSize()[1] : matrix.GetSize()[0];
        int n3 = this.GetSize()[1];
        double d = 1.0;
        double d2 = 0.0;
        double[][] dArray = new double[n][n2];
        DGEMM.DGEMM((String)string2, (String)string, (int)n, (int)n2, (int)n3, (double)d, (double[][])this.GetContent(), (double[][])matrix.GetContent(), (double)d2, (double[][])dArray);
        Matrix matrix2 = new Matrix(n, n2);
        matrix2.SetContent(dArray);
        return matrix2;
    }

    public Matrix trans() {
        int n;
        Matrix matrix = new Matrix(this.GetSize()[1], this.GetSize()[1]);
        for (n = 0; n < this.GetSize()[1]; ++n) {
            matrix.SetContent(n, n, 1.0);
        }
        matrix = matrix.mult(this, "t");
        matrix.Merges = this.Merges;
        matrix.MergesUnder = this.MergesUnder;
        for (n = 0; n < this.MergesUnder.length; ++n) {
            matrix.MergesUnder[n] = !this.MergesUnder[n];
        }
        return matrix;
    }

    public Matrix add(Matrix matrix) {
        if (this.GetSize()[0] != matrix.GetSize()[0] || this.GetSize()[1] != matrix.GetSize()[1]) {
            System.out.println("M\u00d6\u00d6\u00d6P");
        }
        Matrix matrix2 = new Matrix(this.GetSize());
        for (int i = 0; i < this.GetSize()[1]; ++i) {
            for (int j = 0; j < this.GetSize()[0]; ++j) {
                matrix2.SetContent(i, j, this.GetContent(i, j) + matrix.GetContent(i, j));
            }
        }
        return matrix2;
    }

    public Matrix mult(double d) {
        Matrix matrix = new Matrix(this.GetSize());
        for (int i = 0; i < this.GetSize()[1]; ++i) {
            for (int j = 0; j < this.GetSize()[0]; ++j) {
                matrix.SetContent(i, j, this.GetContent(i, j) * d);
            }
        }
        return matrix;
    }

    public Matrix neg() {
        Matrix matrix = new Matrix(this.GetSize());
        for (int i = 0; i < this.GetSize()[1]; ++i) {
            for (int j = 0; j < this.GetSize()[0]; ++j) {
                matrix.SetContent(i, j, -this.GetContent(i, j));
            }
        }
        return matrix;
    }

    public Matrix sub(Matrix matrix) {
        return this.add(matrix.neg());
    }

    public Matrix svd(Matrix matrix, Matrix matrix2) {
        String string = "S";
        String string2 = "S";
        double[] dArray = new double[this.Size[1] < this.Size[0] ? this.Size[1] : this.Size[0]];
        int n = 5 * dArray.length + (this.Size[1] > this.Size[0] ? this.Size[1] : this.Size[0]);
        double[] dArray2 = new double[n];
        intW intW2 = new intW(0);
        if (this.Size[1] < this.Size[0]) {
            matrix.SetSize(this.Size[1], this.Size[0]);
            matrix2.SetSize(this.Size[1], this.Size[1]);
        } else {
            matrix.SetSize(this.Size[0], this.Size[0]);
            matrix2.SetSize(this.Size[1], this.Size[0]);
        }
        DGESVD.DGESVD((String)string, (String)string2, (int)this.Size[0], (int)this.Size[1], (double[][])this.GetContent(), (double[])dArray, (double[][])matrix.GetContent(), (double[][])matrix2.GetContent(), (double[])dArray2, (int)n, (intW)intW2);
        matrix.Merges = this.Merges;
        matrix.MergesUnder = this.MergesUnder;
        matrix2.Merges = this.Merges;
        matrix2.MergesUnder = this.MergesUnder;
        Matrix matrix3 = new Matrix(dArray.length, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            matrix3.SetContent(i, i, dArray[i]);
        }
        return matrix3;
    }

    public int merge(Matrix matrix, boolean bl) {
        if (bl) {
            int n;
            int n2;
            if (matrix.GetSize()[1] != this.GetSize()[1]) {
                return -1;
            }
            Matrix matrix2 = new Matrix(this.GetSize()[1], this.GetSize()[0] + matrix.GetSize()[0]);
            matrix2.Merges = new int[this.Merges.length + 1];
            matrix2.Merges[this.Merges.length] = this.GetSize()[0];
            matrix2.MergesUnder = new boolean[this.MergesUnder.length + 1];
            matrix2.MergesUnder[this.MergesUnder.length] = true;
            for (n2 = 0; n2 < this.GetSize()[0]; ++n2) {
                for (n = 0; n < this.GetSize()[1]; ++n) {
                    matrix2.SetContent(n, n2, this.GetContent(n, n2));
                }
            }
            for (n2 = 0; n2 < matrix.GetSize()[0]; ++n2) {
                for (n = 0; n < matrix.GetSize()[1]; ++n) {
                    matrix2.SetContent(n, n2 + this.GetSize()[0], matrix.GetContent(n, n2));
                }
            }
            this.Content = matrix2.GetContent();
            this.Size = matrix2.GetSize();
            this.Merges = matrix2.Merges;
            this.MergesUnder = matrix2.MergesUnder;
        } else {
            int n;
            int n3;
            if (matrix.GetSize()[0] != this.GetSize()[0]) {
                return -1;
            }
            Matrix matrix3 = new Matrix(this.GetSize()[1] + matrix.GetSize()[1], this.GetSize()[0]);
            matrix3.Merges = new int[this.Merges.length + 1];
            matrix3.Merges[this.Merges.length] = this.GetSize()[1];
            matrix3.MergesUnder = new boolean[this.MergesUnder.length + 1];
            matrix3.MergesUnder[this.MergesUnder.length] = false;
            for (n3 = 0; n3 < this.GetSize()[0]; ++n3) {
                for (n = 0; n < this.GetSize()[1]; ++n) {
                    matrix3.SetContent(n, n3, this.GetContent(n, n3));
                }
            }
            for (n3 = 0; n3 < matrix.GetSize()[0]; ++n3) {
                for (n = 0; n < matrix.GetSize()[1]; ++n) {
                    matrix3.SetContent(n + this.GetSize()[1], n3, matrix.GetContent(n, n3));
                }
            }
            this.Content = matrix3.GetContent();
            this.Size = matrix3.GetSize();
            this.Merges = matrix3.Merges;
            this.MergesUnder = matrix3.MergesUnder;
        }
        return 0;
    }

    public Matrix split() {
        int n;
        int n2;
        if (this.Merges.length == 0) {
            return this;
        }
        if (this.MergesUnder[this.MergesUnder.length - 1]) {
            int n3;
            int n4;
            Matrix matrix = new Matrix(this.GetSize()[1], this.Merges[this.Merges.length - 1]);
            Matrix matrix2 = new Matrix(this.GetSize()[1], this.GetSize()[0] - this.Merges[this.Merges.length - 1]);
            matrix.Merges = new int[this.Merges.length - 1];
            for (n4 = 0; n4 < this.Merges.length - 1; ++n4) {
                matrix.Merges[n4] = this.Merges[n4];
            }
            matrix.MergesUnder = new boolean[this.MergesUnder.length - 1];
            for (n4 = 0; n4 < this.MergesUnder.length - 1; ++n4) {
                matrix.MergesUnder[n4] = this.MergesUnder[n4];
            }
            for (n4 = 0; n4 < matrix.GetSize()[0]; ++n4) {
                for (n3 = 0; n3 < matrix.GetSize()[1]; ++n3) {
                    matrix.SetContent(n3, n4, this.GetContent(n3, n4));
                }
            }
            for (n4 = 0; n4 < matrix2.GetSize()[0]; ++n4) {
                for (n3 = 0; n3 < matrix2.GetSize()[1]; ++n3) {
                    matrix2.SetContent(n3, n4, this.GetContent(n3, n4 + matrix.GetSize()[0]));
                }
            }
            this.Content = matrix.GetContent();
            this.Size = matrix.GetSize();
            this.Merges = matrix.Merges;
            this.MergesUnder = matrix.MergesUnder;
            return matrix2;
        }
        Matrix matrix = new Matrix(this.Merges[this.Merges.length - 1], this.GetSize()[0]);
        Matrix matrix3 = new Matrix(this.GetSize()[1] - this.Merges[this.Merges.length - 1], this.GetSize()[0]);
        matrix.Merges = new int[this.Merges.length - 1];
        for (n2 = 0; n2 < this.Merges.length - 1; ++n2) {
            matrix.Merges[n2] = this.Merges[n2];
        }
        matrix.MergesUnder = new boolean[this.MergesUnder.length - 1];
        for (n2 = 0; n2 < this.MergesUnder.length - 1; ++n2) {
            matrix.MergesUnder[n2] = this.MergesUnder[n2];
        }
        for (n2 = 0; n2 < matrix.GetSize()[0]; ++n2) {
            for (n = 0; n < matrix.GetSize()[1]; ++n) {
                matrix.SetContent(n, n2, this.GetContent(n, n2));
            }
        }
        for (n2 = 0; n2 < matrix3.GetSize()[0]; ++n2) {
            for (n = 0; n < matrix3.GetSize()[1]; ++n) {
                matrix3.SetContent(n, n2, this.GetContent(n + matrix.GetSize()[1], n2));
            }
        }
        this.Content = matrix.GetContent();
        this.Size = matrix.GetSize();
        this.Merges = matrix.Merges;
        this.MergesUnder = matrix.MergesUnder;
        return matrix3;
    }

    public double Trace() {
        double d = 0.0;
        if (this.GetSize()[0] != this.GetSize()[1]) {
            return 0.0;
        }
        for (int i = 0; i < this.GetSize()[0]; ++i) {
            d += this.GetContent(i, i);
        }
        return d;
    }

    public double[] Eigen() {
        if (this.GetSize()[0] != this.GetSize()[1]) {
            return new double[0];
        }
        double[] dArray = new double[this.GetSize()[0]];
        int n = this.GetSize()[0] * this.GetSize()[0];
        double[] dArray2 = new double[n];
        intW intW2 = new intW(0);
        DSYEV.DSYEV((String)"V", (String)"U", (int)this.GetSize()[0], (double[][])this.GetContent(), (double[])dArray, (double[])dArray2, (int)n, (intW)intW2);
        return dArray;
    }
}

