/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ZoomableChart
extends Chart2D
implements MouseListener,
MouseMotionListener {
    private int m_lastPressedButton;
    private Point2D m_startPoint;
    private IRangePolicy m_zoomAllRangePolicy = new RangePolicyUnbounded();
    private Rectangle2D m_zoomArea;

    public ZoomableChart() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.m_lastPressedButton != 1) {
            return;
        }
        if (e.getY() >= 20 && e.getY() <= this.getYChartStart() && e.getX() >= 20 && e.getX() <= this.getXChartEnd()) {
            double endY;
            double startY;
            double endX;
            double startX;
            if ((double)e.getX() > this.m_startPoint.getX()) {
                startX = this.m_startPoint.getX();
                endX = e.getX();
            } else {
                startX = e.getX();
                endX = this.m_startPoint.getX();
            }
            if (startX < (double)this.getXChartStart()) {
                startX = this.getXChartStart();
            }
            if (endX > (double)(this.getWidth() - 20)) {
                endX = this.getWidth() - 20;
            }
            if ((double)e.getY() > this.m_startPoint.getY()) {
                startY = this.m_startPoint.getY();
                endY = e.getY();
            } else {
                startY = e.getY();
                endY = this.m_startPoint.getY();
            }
            if (startY > (double)this.getYChartStart()) {
                startY = this.getYChartStart();
            }
            if (endY > (double)(this.getHeight() - 20)) {
                endY = this.getHeight() - 20;
            }
            double dimX = endX - startX;
            double dimY = endY - startY;
            this.m_zoomArea = new Rectangle2D.Double(startX, startY, dimX, dimY);
            this.setRequestedRepaint(true);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.m_startPoint = new Point2D.Double(e.getX(), e.getY());
        this.m_lastPressedButton = e.getButton();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_zoomArea != null) {
            IAxis axisX = this.getAxisX();
            IAxis axisY = this.getAxisY();
            double startPx = this.m_zoomArea.getX();
            double endPx = this.m_zoomArea.getX() + this.m_zoomArea.getWidth();
            double xAxisMin = axisX.translatePxToValue((int)startPx);
            double xAxisMax = axisX.translatePxToValue((int)endPx);
            double startPy = this.m_zoomArea.getY();
            double endPy = this.m_zoomArea.getY() + this.m_zoomArea.getHeight();
            double yAxisMin = axisY.translatePxToValue((int)startPy);
            double yAxisMax = axisY.translatePxToValue((int)endPy);
            if (endPx - startPx < 20.0 || endPy - startPy < 20.0) {
                this.m_zoomArea = null;
                this.setRequestedRepaint(true);
                return;
            }
            this.zoom(xAxisMin, xAxisMax, yAxisMin, yAxisMax);
        }
    }

    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.m_zoomArea != null) {
            g2.draw(this.m_zoomArea);
            g2.setPaint(new Color(255, 255, 0, 100));
            g2.fill(this.m_zoomArea);
        }
    }

    public void zoom(double xmin, double xmax) {
        this.m_zoomArea = null;
        IAxis axis = this.getAxisX();
        RangePolicyFixedViewport zoomPolicy = new RangePolicyFixedViewport(new Range(xmin, xmax));
        axis.setRangePolicy(zoomPolicy);
    }

    public void zoom(double xmin, double xmax, double ymin, double ymax) {
        this.m_zoomArea = null;
        IAxis axisX = this.getAxisX();
        RangePolicyFixedViewport zoomPolicyX = new RangePolicyFixedViewport(new Range(xmin, xmax));
        axisX.setRangePolicy(zoomPolicyX);
        IAxis axisY = this.getAxisY();
        RangePolicyFixedViewport zoomPolicyY = new RangePolicyFixedViewport(new Range(ymin, ymax));
        axisY.setRangePolicy(zoomPolicyY);
    }

    public void zoomAll() {
        this.getAxisX().setRangePolicy(this.m_zoomAllRangePolicy);
        this.getAxisY().setRangePolicy(this.m_zoomAllRangePolicy);
    }
}

