package dmrgvisu;

import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.io.ADataCollector;

public class DMRGWFCollector extends ADataCollector
{
	public DMRG dmrgRef;
	
	public DMRGWFCollector(ITrace2D trace, long latency)
	{
		super(trace, latency);
	}
	
	public void SetDMRG(DMRG dmrgRef)
	{
		this.dmrgRef = dmrgRef;
	}
	
	public TracePoint2D collectData()
	{
		double []NewPoint = this.dmrgRef.GetNextWF();
		if (NewPoint[0] == -1 && NewPoint[1] == -1)
		{
			NewPoint[0] = this.dmrgRef.OldY;
			NewPoint[1] = this.dmrgRef.OldWf;
		}
		TracePoint2D Point = new TracePoint2D(NewPoint[0], NewPoint[1]);
		try
		{
			java.io.FileWriter output = new java.io.FileWriter("wf.dat", true);
			String outString = NewPoint[0] + " " + NewPoint[1] + "\n";
			output.write(outString);
			output.close();
		} 
		catch (java.io.IOException e)
		{
			System.out.println("Fehler beim Schreiben der Datei");
		}
		return Point;
	}
}
