package dmrgvisu;
/*
 *  dmrgvisu is the 1-particle-DMRG-Applet.
 *  Copyright (C) 2010 - 2011 Thomas Koehler, created on 11.10.2011.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  If you modify or optimize the code in a useful way please let me know.
 *  pcknow@gmx.de
 *
 */

 
import org.netlib.lapack.DSYEV;
import org.netlib.util.*;
 
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.events.Chart2DActionSaveImageSingleton;
import info.monitorenter.gui.chart.io.ADataCollector;
import info.monitorenter.gui.chart.io.RandomDataCollectorOffset;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.Trace2DReplacing;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.traces.painters.TracePainterLine;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JTextArea;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JComboBox;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.netlib.lapack.DSYEV;
import org.netlib.util.*;

public final class DMRGshow extends JApplet 
{ 
	final class ControlPanel extends JPanel 
	{
		private static final long serialVersionUID = 1L;

		/** Slider fr die Gre des Systems */
		private JSlider m_systemSizeSlider;		
		
		/** Slider fr die Anzahl der Sttzstellen */
		private JSlider m_amountOfSamplingpointsSlider;

		/** Slider fr die Anzahl der Sweeps */
		private JSlider m_amountOfSweepsSlider;

		/** Start/Pause-Button */
		public JButton m_startStop;		
		
		/** Clear-Button */
		private JButton m_clear;
		
		/** Reset-Button */
		private JButton m_reset ;
		
		/** Potential-Auswahl */
		private JComboBox m_potChooser;

		/** System-Size Text */
		public JTextArea m_sysSizeText;		
	
		/** Potential-Auswahl */
		public JTextArea m_sysSamplingText;

		/** Potential-Auswahl */
		public JTextArea m_sysSweepText;		
		
		protected ControlPanel() 
		{
			//this.setSize(100, 100);
			this.setBackground(Color.WHITE);
			
			// Erzeugen der einzelnen Kontrollfelder
			this.createClearButton();
			
			this.createSizeText();
			this.createSamplingText();
			this.createSweepText();
			this.createSamplingSlider();
			this.createSystemSizeSlider();
			this.createSweepsSlider();
			this.createStartStopButton();
			this.createResetButton();
			this.createPotChooser();
			
			// Layouting: Vertikale Anordnung der Slider
			JComponent SliderBox = new JPanel();		// Box in der alle Slider enthalten sind
			SliderBox.setBackground(Color.WHITE);
			SliderBox.setLayout(new BoxLayout(SliderBox, BoxLayout.X_AXIS));
			this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
			SliderBox.add(this.m_systemSizeSlider);
			SliderBox.add(this.m_amountOfSamplingpointsSlider);
			SliderBox.add(this.m_amountOfSweepsSlider);
			this.add(SliderBox);
			
			JComponent TextBox = new JPanel();	// Box fr die Textausgabe
			TextBox.setBackground(Color.WHITE);
			TextBox.setLayout(new BoxLayout(TextBox, BoxLayout.X_AXIS));
			TextBox.add(Box.createHorizontalGlue());
			TextBox.add(this.m_sysSizeText);
			TextBox.add(Box.createHorizontalGlue());
			TextBox.add(this.m_sysSamplingText);
			TextBox.add(Box.createHorizontalGlue());
			TextBox.add(this.m_sysSweepText);
			this.add(TextBox);
			
			JComponent StartClearResetBox = new JPanel();	// Box fr den Start/Pause- und den Clear-Button
			StartClearResetBox.setBackground(Color.WHITE);
			StartClearResetBox.setLayout(new BoxLayout(StartClearResetBox, BoxLayout.X_AXIS));
			StartClearResetBox.add(Box.createHorizontalGlue());
			StartClearResetBox.add(this.m_startStop);
			StartClearResetBox.add(Box.createHorizontalGlue());
			StartClearResetBox.add(this.m_clear);
			StartClearResetBox.add(Box.createHorizontalGlue());
			StartClearResetBox.add(this.m_reset);
			this.add(StartClearResetBox);

			JComponent PotBox = new JPanel();		// Box fr die Potential-Auswahl
			PotBox.setBackground(Color.WHITE);
			PotBox.setLayout(new BoxLayout(PotBox, BoxLayout.X_AXIS));
			PotBox.add(Box.createHorizontalGlue());			
			
			PotBox.add(Box.createHorizontalGlue());
			PotBox.add(this.m_potChooser);
			this.add(PotBox);
		}

		private void createPotChooser() 
		{
			this.m_potChooser = new JComboBox();
			this.m_potChooser.setBackground(Color.WHITE);
			this.m_potChooser.addItem("Kein Potential");
			this.m_potChooser.addItem("Harmonisches Potential");
			this.m_potChooser.addItem("Anharmonisches Potential");
			this.m_potChooser.addItem("Doppelmulden-Potential");
			this.m_potChooser.addItem("Rechteck-Potential");

			this.m_potChooser.setSelectedIndex(0);
			this.m_potChooser.setMaximumSize(new Dimension(200, this.m_clear.getMaximumSize().height));
			this.m_potChooser.addActionListener
			(
				new ActionListener() 
				{
					public void actionPerformed(final ActionEvent ae) 
					{
						int value = ((JComboBox) ae.getSource()).getSelectedIndex();
						DMRGshow.this.Pot = value;
						DMRGshow.this.stopData();
						DMRGshow.this.clearTrace();
						DMRGshow.this.resetDMRG();
						DMRGshow.this.conPan.m_startStop.setText("start");
					}
				}
			);
		}		
		
		private void createSamplingSlider() 
		{
			this.m_amountOfSamplingpointsSlider = new JSlider(JSlider.VERTICAL, 10, 5000, DMRGshow.this.Samplings);
			this.m_sysSamplingText.setText(""+DMRGshow.this.Samplings);
			this.m_amountOfSamplingpointsSlider.setBackground(Color.WHITE);
			this.m_amountOfSamplingpointsSlider.setMajorTickSpacing(500);
			this.m_amountOfSamplingpointsSlider.setMinorTickSpacing(2);
			this.m_amountOfSamplingpointsSlider.setSnapToTicks(true);
			this.m_amountOfSamplingpointsSlider.setPaintLabels(true);
			this.m_amountOfSamplingpointsSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Samples", TitledBorder.LEFT, TitledBorder.BELOW_TOP));
			this.m_amountOfSamplingpointsSlider.setPaintTicks(true);
			this.m_amountOfSamplingpointsSlider.addChangeListener
			(
				new ChangeListener() 
				{
					public void stateChanged(final ChangeEvent e) 
					{
						JSlider source = (JSlider) e.getSource();
						if (!source.getValueIsAdjusting()) 
						{
							int value = source.getValue();
							DMRGshow.this.Samplings = value;
							DMRGshow.this.conPan.m_sysSamplingText.setText(""+value);
							DMRGshow.this.stopData();
							DMRGshow.this.clearTrace();
							DMRGshow.this.resetDMRG();
							DMRGshow.this.conPan.m_startStop.setText("start");
						}
					}
				}
			);

		}

		private void createSweepsSlider() 



		{
			this.m_amountOfSweepsSlider = new JSlider(JSlider.VERTICAL, 0, 100, DMRGshow.this.Sweeps);
			this.m_sysSweepText.setText(""+DMRGshow.this.Sweeps);
			this.m_amountOfSweepsSlider.setBackground(Color.WHITE);
			this.m_amountOfSweepsSlider.setMajorTickSpacing(10);
			this.m_amountOfSweepsSlider.setMinorTickSpacing(1);
			this.m_amountOfSweepsSlider.setSnapToTicks(true);
			this.m_amountOfSweepsSlider.setPaintLabels(true);
			this.m_amountOfSweepsSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sweeps", TitledBorder.LEFT, TitledBorder.BELOW_TOP));
			this.m_amountOfSweepsSlider.setPaintTicks(true);
			this.m_amountOfSweepsSlider.addChangeListener
			(
				new ChangeListener() 
				{
					public void stateChanged(final ChangeEvent e) 
					{
						JSlider source = (JSlider) e.getSource();
						if (!source.getValueIsAdjusting()) 
						{
							int value = source.getValue();
							DMRGshow.this.Sweeps = value;
							DMRGshow.this.conPan.m_sysSweepText.setText(""+value);
							DMRGshow.this.stopData();
							DMRGshow.this.clearTrace();
							DMRGshow.this.resetDMRG();
							DMRGshow.this.conPan.m_startStop.setText("start");
						}
					}
				}
			);
		}
		
		private void createSystemSizeSlider() 
		{
			this.m_systemSizeSlider = new JSlider(JSlider.VERTICAL, 1, 101, DMRGshow.this.SystemSize);
			this.m_sysSizeText.setText(""+DMRGshow.this.SystemSize);
			this.m_systemSizeSlider.setBackground(Color.WHITE);
			this.m_systemSizeSlider.setMajorTickSpacing(5);
			this.m_systemSizeSlider.setMinorTickSpacing(1);
			this.m_systemSizeSlider.setSnapToTicks(true);
			this.m_systemSizeSlider.setPaintLabels(true);
			this.m_systemSizeSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Size", TitledBorder.LEFT, TitledBorder.BELOW_TOP));
			this.m_systemSizeSlider.setPaintTicks(true);
			this.m_systemSizeSlider.addChangeListener
			(
				new ChangeListener() 
				{
					public void stateChanged(final ChangeEvent e) 
					{
						JSlider source = (JSlider) e.getSource();
						if (!source.getValueIsAdjusting()) 
						{
							int value = source.getValue();
							DMRGshow.this.SystemSize = value;
							DMRGshow.this.conPan.m_sysSizeText.setText(""+value);
							DMRGshow.this.stopData();
							DMRGshow.this.clearTrace();
							DMRGshow.this.resetDMRG();
							DMRGshow.this.conPan.m_startStop.setText("start");
						}
					}
				}
			);
		}	

		private void createClearButton() 
		{
			this.m_clear = new JButton("clear");
			this.m_clear.setBackground(Color.WHITE);
			this.m_clear.addActionListener
			(
				new ActionListener() 
				{
					public void actionPerformed(final ActionEvent e) 
					{
						DMRGshow.this.clearTrace();
					}
				}
			);
		}

		private void createResetButton() 
		{
			this.m_reset = new JButton("reset");
			this.m_reset.setBackground(Color.WHITE);
			this.m_reset.addActionListener
			(
				new ActionListener() 
				{
					public void actionPerformed(final ActionEvent e) 
					{
						DMRGshow.this.stopData();
						DMRGshow.this.clearTrace();
						DMRGshow.this.resetDMRG();
						DMRGshow.this.conPan.m_startStop.setText("start");
					}
				}
			);
		}		
		
		private void createStartStopButton() 
		{
			this.m_startStop = new JButton("start");
			this.m_startStop.setBackground(Color.WHITE);
			this.m_startStop.addActionListener
			(
				new ActionListener() 
				{
					public void actionPerformed(final ActionEvent e) 
					{
						JButton source = (JButton) e.getSource();
						if (DMRGshow.this.getEnergyCollector().isRunning()) 
						{
							DMRGshow.this.stopData();
							source.setText("start");
						} 
						else 
						{
							DMRGshow.this.startData();
							source.setText("stop");
						}
						source.invalidate();
						source.repaint();
					}
				}
			);
		}
		
		private void createSizeText() 
		{
			this.m_sysSizeText = new JTextArea("0");
			this.m_sysSizeText.setMaximumSize(new Dimension(200, this.m_clear.getMaximumSize().height));
			this.m_sysSizeText.setEditable(false);
			this.m_sysSizeText.setBackground(Color.WHITE);
			this.m_sysSizeText.setBorder(BorderFactory.createEtchedBorder());
		}

		private void createSamplingText() 
		{
			this.m_sysSamplingText = new JTextArea("0");
			this.m_sysSamplingText.setMaximumSize(new Dimension(200, this.m_clear.getMaximumSize().height));
			this.m_sysSamplingText.setEditable(false);
			this.m_sysSamplingText.setBackground(Color.WHITE);
			this.m_sysSamplingText.setBorder(BorderFactory.createEtchedBorder());
		}
		
		private void createSweepText() 
		{
			this.m_sysSweepText = new JTextArea("0");
			this.m_sysSweepText.setMaximumSize(new Dimension(200, this.m_clear.getMaximumSize().height));
			this.m_sysSweepText.setEditable(false);
			this.m_sysSweepText.setBackground(Color.WHITE);
			this.m_sysSweepText.setBorder(BorderFactory.createEtchedBorder());
		}		
		
	}

	public static void main(String[] args)
	{
		JFrame frame = new JFrame("DMRGshow");
		DMRGshow show = new DMRGshow();
		show.init();
		frame.getContentPane().add(show);
		frame.setSize(1024, 600);
		frame.addWindowListener
		(
			new WindowAdapter() 
			{
				@Override
				public void windowClosing(final WindowEvent e) 
				{
					System.exit(0);
				}
			}
		);
		frame.setVisible(true);	
	}
	
	/** Energie-Chart */
	protected Chart2D m_energy_chart;

	/** Energie-Data-Collector */
	private transient ADataCollector m_energy_collector;

	/** Energie-Trace */
	private Trace2DSimple m_energy_trace;

	/** Energie-Trace fr die exakte Lsung */
	private Trace2DReplacing m_ex_energy_trace;

	/** Wellenfunktions-Chart */
	protected Chart2D m_wf_chart;

	/** Wellenfunktions-Data-Collector */
	private transient ADataCollector m_wf_collector;
	
	/** Wellenfunktions-Trace */
	private Trace2DSimple m_wf_trace;
	
	/** Wellenfunktions-Trace fr die exakte Lsung */
	private Trace2DReplacing m_ex_wf_trace;
	
	/** Halbe reale Systemgre */
	public int SystemSize;
	
	/** Maximale Anzahl der auszufhrenden Sweeps */
	public int Sweeps;
	
	/** Anzahl der Sttzstellen */
	public int Samplings;
	
	/** Auswahl des Potentials (s. DMRG.potentialChooser) */
	public int Pot;														// Ggf durch verweis auf DMRGref ersetzen...
	
	/** Komplettes Control-Panel */
	public ControlPanel conPan;
	
	/** Panel fr die Energieausgabe */
	public ChartPanel energychartpanel;
	
	/** Panel fr die Wellenfunktionsausgabe */
	public ChartPanel wfchartpanel;
	
	/** Referenz auf ein DMRG-Objekt (dort wird die gesamte Rechnung durchgefhrt) */
	public DMRG DMRGref;
	
	/** Energieausgabe */
	public JTextArea EnergyText;

	/** Sweepausgabe */
	public JTextArea SweepText;
	
	public DMRGshow() 
	{
		super();
	}

	public synchronized void clearTrace() 
	{
		this.getEnergyTrace().removeAllPoints();
		this.getWFTrace().removeAllPoints();
	}

	public void setEnergyChart(final Chart2D chart2D) 
	{
		if (this.m_energy_chart == null) 
		{
			this.m_energy_chart = chart2D;
		}
	}

	public Chart2D getEnergyChart() 
	{
		return this.m_energy_chart;
	}

	private void setEnergyCollector(final DMRGEnergyCollector collector) 
	{
		this.m_energy_collector = collector;
	}

	public ADataCollector getEnergyCollector() 
	{
		return this.m_energy_collector;
	}

	public void setEnergyTrace(final Trace2DSimple trace) 
	{
		if (this.m_energy_trace == null) 
		{
			this.m_energy_trace = trace;
		}
	}
	
	public Trace2DSimple getEnergyTrace() 
	{
		return this.m_energy_trace;
	}

	public void setExEnergyTrace(final Trace2DReplacing trace) 
	{
		if (this.m_ex_energy_trace == null) 
		{
			this.m_ex_energy_trace = trace;
		}
	}
	
	public Trace2DReplacing getExEnergyTrace() 
	{
		return this.m_ex_energy_trace;
	}

	public void setWFChart(final Chart2D chart2D) 
	{
		if (this.m_wf_chart == null) 
		{
			this.m_wf_chart = chart2D;
		}
	}
	
	public Chart2D getWFChart() 
	{
		return this.m_wf_chart;
	}

	private void setWFCollector(final DMRGWFCollector collector) 
	{
		this.m_wf_collector = collector;
	}	
	
	public ADataCollector getWFCollector() 
	{
		return this.m_wf_collector;
	}	

	public void setWFTrace(final Trace2DSimple trace) 
	{
		if (this.m_wf_trace == null) 
		{
			this.m_wf_trace = trace;
		}
	}
	
	public Trace2DSimple getWFTrace() 
	{
		return this.m_wf_trace;
	}

	public void setExWFTrace(final Trace2DReplacing trace) 
	{
		if (this.m_ex_wf_trace == null) 
		{
			this.m_ex_wf_trace = trace;
		}
	}	
	
	public Trace2DReplacing getExWFTrace() 
	{
		return this.m_ex_wf_trace;
	}
	
	@Override
	public void init() 
	{
		super.init();
		this.setSize(new Dimension(1024, 600));
		
		/** Setzen der wesentlichen Variablen. Werden nur fr die Initialisierung gebraucht. */
		this.SystemSize = 5;
		this.Sweeps = 50;
		this.Samplings = 100;
		this.Pot = 0;	
		
		try
		{
			java.io.FileWriter output = new java.io.FileWriter("wf.dat");
			output.close();
			output = new java.io.FileWriter("en.dat");
			output.close();
		} 
		catch (java.io.IOException e)
		{
			System.out.println("Fehler beim Leeren der Datei");
		}
		
		Chart2D energy = new Chart2D();
		this.setEnergyChart(energy);
		this.getEnergyChart().getAxisX().setPaintGrid(true);
		this.getEnergyChart().getAxisY().setPaintGrid(true);		
		this.getEnergyChart().setGridColor(Color.LIGHT_GRAY);
		this.setEnergyTrace(new Trace2DSimple());
		this.getEnergyTrace().setTracePainter(new TracePainterDisc());
		this.getEnergyTrace().setName("DMRG");
		this.getEnergyTrace().setPhysicalUnits("Location", "Energy");
		this.getEnergyTrace().setColor(Color.RED);
		this.setExEnergyTrace(new Trace2DReplacing());
		this.getExEnergyTrace().addTracePainter(new TracePainterLine());
		this.getExEnergyTrace().setName("Analytic Solution");
		this.getExEnergyTrace().setPhysicalUnits("Location", "Energy");
		this.getExEnergyTrace().setColor(Color.BLUE);
		this.getEnergyChart().addTrace(this.getEnergyTrace());
		this.getEnergyChart().addTrace(this.getExEnergyTrace());
		
		Chart2D wf = new Chart2D();
		this.setWFChart(wf);
		this.getWFChart().getAxisX().setPaintGrid(true);
		this.getWFChart().getAxisY().setPaintGrid(true);
		this.getWFChart().setGridColor(Color.LIGHT_GRAY);
		this.setWFTrace(new Trace2DSimple());
		this.getWFTrace().setTracePainter(new TracePainterDisc());
		this.getWFTrace().setName("DMRG");
		this.getWFTrace().setPhysicalUnits("Location", "Psi");
		this.getWFTrace().setColor(Color.RED);
		this.setExWFTrace(new Trace2DReplacing());
		this.getExWFTrace().addTracePainter(new TracePainterLine());
		this.getExWFTrace().setName("Analytic Solution");
		this.getExWFTrace().setPhysicalUnits("Location", "Psi");
		this.getExWFTrace().setColor(Color.BLUE);
		this.getWFChart().addTrace(this.getWFTrace());
		this.getWFChart().addTrace(this.getExWFTrace());
		
		// Layouting: Horizontale Anordnung der Panels		
		Container content = this.getContentPane();
		content.setLayout(new BoxLayout(content, BoxLayout.X_AXIS));		
		
		JComponent Output = new JPanel();
		Output.setBackground(Color.WHITE);
		Output.setLayout(new BoxLayout(Output, BoxLayout.Y_AXIS));
		
		JComponent Charts = new JPanel();
		Charts.setBackground(Color.WHITE);
		Charts.setLayout(new BoxLayout(Charts, BoxLayout.X_AXIS));
		LayoutFactory factory = LayoutFactory.getInstance();
		// Energie-Panel
		ChartPanel energychartpanel = new ChartPanel(energy);
		Charts.add(energychartpanel);
		Charts.addPropertyChangeListener(energychartpanel);
		// Wellenfunktionspanel
		ChartPanel wfchartpanel = new ChartPanel(wf);
		Charts.add(wfchartpanel);
		Charts.addPropertyChangeListener(wfchartpanel);
		
		Output.add(Charts);
		
		this.DMRGref = new DMRG(this.Samplings, this.SystemSize, this.Sweeps, this.Pot);
		
		// Control-Panel
		this.conPan = new ControlPanel();
		
		JComponent TextOutput = new JPanel();
		TextOutput.setBackground(Color.WHITE);
		TextOutput.setLayout(new BoxLayout(TextOutput, BoxLayout.X_AXIS));
		
		TextOutput.add(Box.createVerticalGlue());
		this.DMRGref.EnergyText = new JTextArea("Minimal energy: infinit");
		this.DMRGref.EnergyText.setMaximumSize(new Dimension(4000, this.conPan.m_startStop.getMaximumSize().height));
		this.DMRGref.EnergyText.setEditable(false);
		this.DMRGref.EnergyText.setBackground(Color.WHITE);
		this.DMRGref.EnergyText.setBorder(BorderFactory.createEtchedBorder());	
		TextOutput.add(this.DMRGref.EnergyText);
		this.DMRGref.SweepText = new JTextArea("Current sweep: 0");
		this.DMRGref.SweepText.setMaximumSize(new Dimension(4000, this.conPan.m_startStop.getMaximumSize().height));
		this.DMRGref.SweepText.setEditable(false);
		this.DMRGref.SweepText.setBackground(Color.WHITE);
		this.DMRGref.SweepText.setBorder(BorderFactory.createEtchedBorder());	
		TextOutput.add(this.DMRGref.SweepText);
		TextOutput.add(Box.createVerticalGlue());
		
		Output.add(TextOutput);
		
		content.add(Output);
		
		content.add(this.conPan);
		
		// Erzeugen der Berechnungsumgebung
		
		
		DMRGEnergyCollector EnergyCollector = new DMRGEnergyCollector(this.getEnergyTrace(), 1);
		EnergyCollector.SetDMRG(this.DMRGref);
		this.setEnergyCollector(EnergyCollector);
		this.DMRGref.SetExEnTrace(this.getExEnergyTrace());
		
		DMRGWFCollector WFCollector = new DMRGWFCollector(this.getWFTrace(), 1);
		WFCollector.SetDMRG(this.DMRGref);
		this.setWFCollector(WFCollector);
		this.DMRGref.SetExWFTrace(this.getExWFTrace());
		
		if (this.DMRGref.potentialChooser == 0 || this.DMRGref.potentialChooser == 1)
			this.DMRGref.CreateExactSolution();
			
		//this.FullDiag();
	}

	public synchronized void startData() 
	{
		if (!this.getEnergyCollector().isRunning()) 
		{
			this.getEnergyCollector().start();
		}
		if (!this.getWFCollector().isRunning()) 
		{
			this.getWFCollector().start();
		}
	}

	public synchronized void stopData() 
	{
		if (this.getEnergyCollector().isRunning()) 
		{
			this.getEnergyCollector().stop();
		}
		if (this.getWFCollector().isRunning()) 
		{
			this.getWFCollector().stop();
		}

	}
	
	public void resetDMRG()
	{
	
		try
		{
			java.io.FileWriter output = new java.io.FileWriter("wf.dat", true);
			String outString = "\n##\n#\n\n";
			output.write(outString);
			output.close();
			
			output = new java.io.FileWriter("en.dat", true);
			output.write(outString);
			output.close();
		} 
		catch (java.io.IOException e)
		{
			System.out.println("Fehler beim Leeren der Datei");
		}
		
		// Erzeugen der Berechnungsumgebung
		DMRG OldDMRG = this.DMRGref;
		this.DMRGref = new DMRG(this.Samplings, this.SystemSize, this.Sweeps, this.Pot);
		
		this.DMRGref.EnergyText = OldDMRG.EnergyText;
		this.DMRGref.EnergyText.setText("Minimal energy: infinit");
		this.DMRGref.SweepText = OldDMRG.SweepText;
		this.DMRGref.SweepText.setText("Current sweep: 0");
		
		((DMRGEnergyCollector)(this.getEnergyCollector())).SetDMRG(this.DMRGref);
		((DMRGWFCollector)(this.getWFCollector())).SetDMRG(this.DMRGref);
		if (this.DMRGref.potentialChooser == 0 || this.DMRGref.potentialChooser == 1)
		{
			this.DMRGref.SetExEnTrace(this.getExEnergyTrace());
			this.getExEnergyTrace().removeAllPoints();

			this.DMRGref.SetExWFTrace(this.getExWFTrace());
			this.getExWFTrace().removeAllPoints();

			this.getEnergyChart().addTrace(this.getExEnergyTrace());
			this.getWFChart().addTrace(this.getExWFTrace());
			
			this.DMRGref.CreateExactSolution();
		}
		else
		{
			this.getEnergyChart().removeTrace(this.getExEnergyTrace());
			this.getWFChart().removeTrace(this.getExWFTrace());
		}
			
	//	this.FullDiag();
	}
	
	public void FullDiag()
	{
		// Berechne mittels kompletter Diagonalisierung (primr als Test)
		int s = this.Samplings;
		double [][]full = new double[s][s];
		for (int i = 0; i<s; i++)
		{
			for (int j = 0; j<s; j++)
			{
				if (i==j)
					full[i][j] = 2.0/Math.pow(DMRGref.h, 2.0)+this.DMRGref.V(i);
				else if (i == j-1 || i==j+1)
					full[i][j] = -1.0/Math.pow(DMRGref.h, 2.0);
				else
					full[i][j] = 0.0;
			}
		}
		double []eva =new double[s];
	    int lwork = s*s;
	    double []work = new double[lwork];
	    intW info = new intW(0);
		DSYEV.DSYEV("V", "U", s, full, eva, work, lwork, info);
		//System.out.println(eva[0]);
	}
}
