package dmrgvisu;

/* Left = -1; Right = 1; */

public class DensityMatrix
{
	double a;
	double b;
	
	public DensityMatrix(WaveFunction WaveFtVector, int lr)
	{
		if (lr == -1)
		{
			a = WaveFtVector.V[0];
			b = WaveFtVector.V[1];
		}
		else
		{
			a = WaveFtVector.V[3];
			b = WaveFtVector.V[2];
		}
	}
	public double []NewBasis()
	{
		double []res = new double[2];
		if (a == 0 && b == 0)
			a = 1.0;
		double norm = Math.sqrt(a*a+b*b);
		res[0] = a/norm;
		res[1] = b/norm;
		return res;
	}
}