/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import com.visutools.nav.bislider.BiSlider;
import com.visutools.nav.bislider.BiSliderListener;
import info.monitorenter.util.MathUtil;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RangeChooserPanel
extends JPanel {
    protected NumberFormat m_nf = NumberFormat.getNumberInstance(Locale.getDefault());
    protected BiSlider m_bislider;

    public RangeChooserPanel(Range range) {
        this.m_nf.setMinimumFractionDigits(2);
        this.m_nf.setMaximumFractionDigits(2);
        double min = range.getMin();
        double max = range.getMax();
        if (!MathUtil.isDouble(min) || min == -1.7976931348623157E308) {
            min = -100.0;
        }
        if (!MathUtil.isDouble(max) || max == Double.MAX_VALUE) {
            max = 100.0;
        }
        double minBound = min - (max - min) / 2.0;
        double maxBound = max + (max - min) / 2.0;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.m_bislider = new BiSlider("CENTRAL");
        this.m_bislider.setMinimumColor(Color.RED.brighter());
        this.m_bislider.setMaximumColor(Color.RED.brighter());
        this.m_bislider.setMinimumValue(minBound);
        this.m_bislider.setMaximumValue(maxBound);
        this.m_bislider.setMinimumColoredValue(min);
        this.m_bislider.setMaximumColoredValue(max);
        this.m_bislider.setSegmentSize(Double.MAX_VALUE);
        this.m_bislider.setPrecise(true);
        this.m_bislider.setArcSize(8);
        this.m_bislider.setInterpolationMode("RGB");
        this.m_bislider.setPreferredSize(new Dimension(200, 30));
        JPanel bisliderPanel = new JPanel();
        bisliderPanel.setLayout(new FlowLayout());
        bisliderPanel.add((Component)this.m_bislider);
        this.add(bisliderPanel);
        this.add(Box.createVerticalStrut(10));
        final JTextField rangeMinView = new JTextField();
        rangeMinView.setText(this.m_nf.format(new Double(this.m_bislider.getMinimumColoredValue())));
        rangeMinView.setEditable(true);
        rangeMinView.setPreferredSize(new Dimension(120, 20));
        rangeMinView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTextField textField = (JTextField)ae.getSource();
                try {
                    Number entered = RangeChooserPanel.this.m_nf.parse(textField.getText());
                    double low = RangeChooserPanel.this.m_bislider.getMinimumColoredValue();
                    double high = RangeChooserPanel.this.m_bislider.getMaximumColoredValue();
                    double minSlider = low - (high - low) / 2.0;
                    RangeChooserPanel.this.m_bislider.setMinimumValue(minSlider);
                    RangeChooserPanel.this.m_bislider.setMinimumColoredValue(entered.doubleValue());
                }
                catch (ParseException e) {
                    textField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_bislider.getMinimumColoredValue()));
                }
            }
        });
        rangeMinView.setToolTipText("Enter a number and hit Return.");
        final JTextField rangeMaxView = new JTextField();
        rangeMaxView.setText(new Double(this.m_bislider.getMaximumColoredValue()).toString());
        rangeMaxView.setEditable(true);
        rangeMaxView.setPreferredSize(new Dimension(120, 20));
        rangeMaxView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTextField textField = (JTextField)ae.getSource();
                try {
                    Number entered = RangeChooserPanel.this.m_nf.parse(textField.getText());
                    double low = RangeChooserPanel.this.m_bislider.getMinimumColoredValue();
                    double high = RangeChooserPanel.this.m_bislider.getMaximumColoredValue();
                    double maxSlider = high + (high - low) / 2.0;
                    RangeChooserPanel.this.m_bislider.setMaximumValue(maxSlider);
                    RangeChooserPanel.this.m_bislider.setMaximumColoredValue(entered.doubleValue());
                }
                catch (ParseException e) {
                    textField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_bislider.getMaximumColoredValue()));
                }
            }
        });
        rangeMaxView.setToolTipText("Enter a number and hit Return.");
        this.m_bislider.addBiSliderListener(new BiSliderListener(){});
        JPanel rangeViewPanel = new JPanel();
        rangeViewPanel.setMaximumSize(new Dimension(300, 30));
        rangeViewPanel.setLayout(new BoxLayout(rangeViewPanel, 0));
        rangeViewPanel.add(Box.createHorizontalGlue());
        rangeViewPanel.add(rangeMinView);
        rangeViewPanel.add(Box.createHorizontalStrut(10));
        rangeViewPanel.add(rangeMaxView);
        rangeViewPanel.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(10));
        this.add(rangeViewPanel);
        this.add(Box.createVerticalGlue());
    }

    public Range getRange() {
        return new Range(this.m_bislider.getMinimumColoredValue(), this.m_bislider.getMaximumColoredValue());
    }
}

