/*
 * Decompiled with CFR 0.152.
 */
package dmrgvisu2;

import dmrgvisu2.Matrix;
import dmrgvisu2.Mpo;
import java.io.IOException;

public class Mps {
    int N;
    Matrix[][] A;
    Matrix[][] L;
    Matrix[][] R;
    int d;
    int d_max;
    int states;

    public Mps() {
        int n;
        System.out.println("DNU");
        this.d = 2;
        this.d_max = 1024;
        this.N = 100000;
        this.states = 2;
        this.A = new Matrix[this.N][this.states];
        this.R = new Matrix[this.N][this.d_max];
        this.L = new Matrix[this.N][this.d_max];
        for (n = 0; n < this.N / 2; ++n) {
            int n2 = (int)(Math.pow(this.d, n + 1) < (double)this.d_max ? Math.pow(this.d, n + 1) : (double)this.d_max);
            int n3 = (int)(Math.pow(this.d, n) < (double)this.d_max ? Math.pow(this.d, n) : (double)this.d_max);
            for (int i = 0; i < this.states; ++i) {
                this.A[n][i] = new Matrix(n2, n3);
                this.A[this.N - n - 1][i] = new Matrix(n3, n2);
            }
        }
        this.FillARandom();
        for (n = 0; n < this.A[this.N - 1][0].GetSize()[1]; ++n) {
            this.R[this.N - 1][n] = new Matrix(1, 1);
            this.R[this.N - 1][n].SetContent(0, 0, 1.0);
        }
        for (n = 0; n < this.A[0][0].GetSize()[1]; ++n) {
            this.L[0][n] = new Matrix(1, 1);
            this.L[0][n].SetContent(0, 0, 1.0);
        }
    }

    public Mps(int n, int n2, int n3, int n4, Mpo mpo) {
        int n5;
        this.d = n2;
        this.d_max = n3;
        this.N = n;
        this.states = n4;
        this.A = new Matrix[this.N][this.states];
        this.R = new Matrix[this.N][this.d_max];
        this.L = new Matrix[this.N][this.d_max];
        for (n5 = 0; n5 < (this.N + 1) / 2; ++n5) {
            int n6 = (int)(Math.pow(n2, n5 + 1) < (double)this.d_max ? Math.pow(n2, n5 + 1) : (double)this.d_max);
            int n7 = (int)(Math.pow(n2, n5) < (double)this.d_max ? Math.pow(n2, n5) : (double)this.d_max);
            for (int i = 0; i < this.states; ++i) {
                this.A[n5][i] = new Matrix(n6, n7);
                this.A[this.N - n5 - 1][i] = new Matrix(n7, n6);
            }
        }
        if (this.N % 2 == 1) {
            for (n5 = 0; n5 < this.states; ++n5) {
                this.A[this.N / 2][n5] = new Matrix((int)(Math.pow(n2, this.N / 2) < (double)n3 ? Math.pow(n2, this.N / 2) : (double)n3), (int)(Math.pow(n2, this.N / 2) < (double)n3 ? Math.pow(n2, this.N / 2) : (double)n3));
            }
        }
        this.FillARandom();
        for (n5 = 0; n5 < this.A[n - 1][0].GetSize()[1]; ++n5) {
            this.R[n - 1][n5] = new Matrix(1, 1);
            this.R[n - 1][n5].SetContent(0, 0, 1.0);
        }
        for (n5 = 0; n5 < this.A[0][0].GetSize()[1]; ++n5) {
            this.L[0][n5] = new Matrix(1, 1);
            this.L[0][n5].SetContent(0, 0, 1.0);
        }
        this.DoLeftSweepFull(mpo);
    }

    public Mps(int n, int n2, int n3, int n4) {
        int n5;
        this.d = n2;
        this.d_max = n3;
        this.N = n;
        this.states = n4;
        this.A = new Matrix[this.N][this.states];
        this.R = new Matrix[this.N][this.d_max];
        this.L = new Matrix[this.N][this.d_max];
        for (n5 = 0; n5 < (this.N + 1) / 2; ++n5) {
            int n6 = (int)(Math.pow(n2, n5 + 1) < (double)n3 ? Math.pow(n2, n5 + 1) : (double)n3);
            int n7 = (int)(Math.pow(n2, n5) < (double)n3 ? Math.pow(n2, n5) : (double)n3);
            for (int i = 0; i < this.states; ++i) {
                this.A[n5][i] = new Matrix(n6, n7);
                this.A[this.N - n5 - 1][i] = new Matrix(n7, n6);
            }
        }
        if (this.N % 2 == 1) {
            for (n5 = 0; n5 < this.states; ++n5) {
                this.A[this.N / 2][n5] = new Matrix((int)(Math.pow(n2, this.N / 2) < (double)n3 ? Math.pow(n2, this.N / 2) : (double)n3), (int)(Math.pow(n2, this.N / 2) < (double)n3 ? Math.pow(n2, this.N / 2) : (double)n3));
            }
        }
        for (n5 = 0; n5 < this.A[n - 1][0].GetSize()[1]; ++n5) {
            this.R[n - 1][n5] = new Matrix(1, 1);
            this.R[n - 1][n5].SetContent(0, 0, 1.0);
        }
        for (n5 = 0; n5 < this.A[0][0].GetSize()[1]; ++n5) {
            this.L[0][n5] = new Matrix(1, 1);
            this.L[0][n5].SetContent(0, 0, 1.0);
        }
    }

    private Matrix ReformMatrix(Matrix matrix) {
        int n;
        int n2;
        Matrix matrix2 = new Matrix(matrix.GetSize()[1] / 2, matrix.GetSize()[0] * 2);
        for (n2 = 0; n2 < matrix2.GetSize()[1]; ++n2) {
            for (n = 0; n < matrix2.GetSize()[0] / 2; ++n) {
                matrix2.SetContent(n2, n, matrix.GetContent(n2, n));
            }
        }
        for (n2 = 0; n2 < matrix2.GetSize()[1]; ++n2) {
            for (n = 0; n < matrix2.GetSize()[0] / 2; ++n) {
                matrix2.SetContent(n2, n + matrix2.GetSize()[0] / 2, matrix.GetContent(n2 + matrix2.GetSize()[1], n));
            }
        }
        matrix2.Merges = new int[this.states - 1];
        matrix2.MergesUnder = new boolean[this.states - 1];
        for (n2 = 0; n2 < this.states - 1; ++n2) {
            matrix2.Merges[n2] = matrix2.GetSize()[0] / 2 * (n2 + 1);
            matrix2.MergesUnder[n2] = true;
        }
        return matrix2;
    }

    public Mps(double[] dArray, int n, Mpo mpo) {
        int n2;
        int n3;
        this.states = n;
        this.N = (int)(Math.log(dArray.length) / Math.log(this.states));
        this.d = 2;
        this.d_max = 1024;
        this.A = new Matrix[this.N][this.states];
        this.R = new Matrix[this.N][this.d_max];
        this.L = new Matrix[this.N][this.d_max];
        Matrix matrix = new Matrix(dArray.length, 1);
        for (n3 = 0; n3 < dArray.length; ++n3) {
            matrix.SetContent(n3, 0, dArray[n3]);
        }
        for (n3 = 1; n3 < this.N; ++n3) {
            Matrix matrix2 = new Matrix();
            Matrix matrix3 = new Matrix();
            Matrix matrix4 = this.ReformMatrix(matrix);
            Matrix matrix5 = matrix4.svd(matrix2, matrix3);
            matrix = matrix5.mult(matrix3);
            for (int i = this.states - 1; i >= 0; --i) {
                this.A[n3 - 1][i] = matrix2.split();
            }
            matrix.Merges = matrix3.Merges;
            matrix.MergesUnder = matrix3.MergesUnder;
        }
        Matrix matrix6 = this.ReformMatrix(matrix);
        for (n2 = this.states - 1; n2 >= 0; --n2) {
            this.A[this.N - 1][n2] = matrix6.split();
        }
        for (n2 = 0; n2 < this.A[this.N - 1][0].GetSize()[1]; ++n2) {
            this.R[this.N - 1][n2] = new Matrix(1, 1);
            this.R[this.N - 1][n2].SetContent(0, 0, 1.0);
        }
        for (n2 = 0; n2 < this.A[this.N - 1][0].GetSize()[1]; ++n2) {
            this.L[this.N - 1][n2] = new Matrix(1, 1);
            this.L[this.N - 1][n2].SetContent(0, 0, 1.0);
        }
        this.DoLeftSweepFull(mpo);
    }

    public void FillARandom() {
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.A[i][j].GetSize()[1]; ++k) {
                    for (int i2 = 0; i2 < this.A[i][j].GetSize()[0]; ++i2) {
                        this.A[i][j].SetContent(k, i2, (int)(Math.random() * 10.0 + 1.0));
                    }
                }
            }
        }
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                string = string + this.A[i][j];
            }
        }
        return string;
    }

    public void printreadable() {
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.states; ++j) {
                System.out.println("A[" + i + "][" + j + "]");
                this.A[i][j].printreadable();
            }
        }
    }

    public void printLreadable() {
        for (int i = 0; i < this.N - 1; ++i) {
            for (int j = 0; j < this.A[i][0].GetSize()[1]; ++j) {
                System.out.println("L[" + i + "][" + j + "]");
                this.L[i][j].printreadable();
            }
        }
    }

    public void printRreadable() {
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.A[i][0].GetSize()[1]; ++j) {
                System.out.println("R[" + i + "][" + j + "]");
                this.R[i][j].printreadable();
            }
        }
    }

    public void DoRightSweepFull(Mpo mpo) {
        for (int i = 0; i < this.N - 1; ++i) {
            this.DoRightSweepStep(i, mpo);
        }
    }

    public void DoLeftSweepFull(Mpo mpo) {
        for (int i = this.N - 1; i > 0; --i) {
            this.DoLeftSweepStep(i, mpo);
        }
    }

    public Matrix DoRightSweepStep(int n, Mpo mpo) {
        int n2;
        Matrix matrix = new Matrix(this.A[n][0]);
        for (int i = 1; i < this.states; ++i) {
            matrix.merge(this.A[n][i], true);
        }
        Matrix matrix2 = new Matrix();
        Matrix matrix3 = new Matrix();
        Matrix matrix4 = matrix.svd(matrix2, matrix3);
        for (n2 = matrix2.Merges.length; n2 >= 0; --n2) {
            this.A[n][n2] = matrix2.split();
        }
        for (n2 = 0; n2 < this.states; ++n2) {
            this.A[n + 1][n2] = matrix4.mult(matrix3).mult(this.A[n + 1][n2]);
        }
        this.BuildL(mpo, n);
        return matrix4;
    }

    public Matrix DoLeftSweepStep(int n, Mpo mpo) {
        int n2;
        Matrix matrix = new Matrix(this.A[n][0]);
        for (int i = 1; i < this.states; ++i) {
            matrix.merge(this.A[n][i], false);
        }
        Matrix matrix2 = new Matrix();
        Matrix matrix3 = new Matrix();
        Matrix matrix4 = matrix.svd(matrix2, matrix3);
        for (n2 = matrix3.Merges.length; n2 >= 0; --n2) {
            this.A[n][n2] = matrix3.split();
        }
        for (n2 = 0; n2 < this.states; ++n2) {
            this.A[n - 1][n2] = this.A[n - 1][n2].mult(matrix2).mult(matrix4);
        }
        this.BuildR(mpo, n - 1);
        return matrix4;
    }

    public void testOrtho() {
        Matrix matrix = new Matrix();
        String string = "";
        for (int i = 0; i < this.N; ++i) {
            int n;
            int n2;
            boolean bl = true;
            boolean bl2 = true;
            matrix = this.A[i][0].trans().mult(this.A[i][0]);
            for (n2 = 1; n2 < this.states; ++n2) {
                matrix = matrix.add(this.A[i][n2].trans().mult(this.A[i][n2]));
            }
            for (n2 = 0; n2 < matrix.GetSize()[0]; ++n2) {
                for (n = 0; n < matrix.GetSize()[1]; ++n) {
                    if ((Math.round(matrix.GetContent(n2, n)) == 0L || n2 == n) && (Math.round(matrix.GetContent(n2, n)) == 1L || n2 != n)) continue;
                    bl = false;
                }
            }
            matrix = this.A[i][0].mult(this.A[i][0].trans());
            for (n2 = 1; n2 < this.states; ++n2) {
                matrix = matrix.add(this.A[i][n2].mult(this.A[i][n2].trans()));
            }
            for (n2 = 0; n2 < matrix.GetSize()[0]; ++n2) {
                for (n = 0; n < matrix.GetSize()[1]; ++n) {
                    if ((Math.round(matrix.GetContent(n2, n)) == 0L || n2 == n) && (Math.round(matrix.GetContent(n2, n)) == 1L || n2 != n)) continue;
                    bl2 = false;
                }
            }
            string = bl && bl2 ? string + "X" : (bl ? string + "A" : (bl2 ? string + "B" : string + "M"));
        }
        System.out.println(string);
    }

    public double ScalarProd(Mps mps) {
        int n;
        if (this.N != mps.N) {
            return 0.0;
        }
        Matrix matrix = new Matrix();
        Matrix matrix2 = new Matrix();
        matrix2 = this.A[0][0].trans().mult(mps.A[0][0]);
        for (n = 1; n < this.states; ++n) {
            matrix2 = matrix2.add(this.A[0][n].trans().mult(mps.A[0][n]));
        }
        matrix = new Matrix(matrix2);
        for (n = 1; n < this.N; ++n) {
            matrix2 = this.A[n][0].trans().mult(matrix).mult(mps.A[n][0]);
            for (int i = 1; i < this.states; ++i) {
                matrix2 = matrix2.add(this.A[n][i].trans().mult(matrix).mult(mps.A[n][i]));
            }
            matrix = new Matrix(matrix2);
        }
        return matrix.GetContent(0, 0);
    }

    public void BuildR(Mpo mpo) {
        System.out.println(this.N);
        for (int i = this.N - 2; i >= 0; --i) {
            this.BuildR(mpo, i);
        }
    }

    public void BuildR(Mpo mpo, int n) {
        Matrix matrix = new Matrix(1, 1);
        matrix.SetContent(0, 0, 1.0);
        for (int i = 0; i < this.A[n + 1][0].GetSize()[0]; ++i) {
            this.R[n][i] = new Matrix(mpo.W[n + 1][0][0].GetSize()[0], this.A[n + 1][0].GetSize()[0]);
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    for (int i2 = 0; i2 < this.A[n + 1][0].GetSize()[1]; ++i2) {
                        if (n > this.N - 2) {
                            for (int i3 = 0; i3 < this.A[n + 1][j].GetSize()[0]; ++i3) {
                                for (int i4 = 0; i4 < mpo.W[n + 1][j][k].GetSize()[0]; ++i4) {
                                    this.R[n][i].SetContent(i4, i3, this.R[n][i].GetContent(i4, i3) + this.A[n + 1][j].GetContent(0, i3) * mpo.W[n + 1][j][k].GetContent(0, i4) * this.A[n + 1][k].GetContent(0, i));
                                }
                            }
                            continue;
                        }
                        this.R[n][i] = new Matrix(this.R[n][i].add(mpo.W[n + 1][j][k].mult(this.R[n + 1][i2].trans()).mult(this.A[n + 1][k].trans()).mult(this.A[n + 1][j].GetContent(i2, i)).trans()));
                    }
                }
            }
        }
    }

    public void BuildL(Mpo mpo) {
        for (int i = 0; i < this.N; ++i) {
            this.BuildL(mpo, i);
        }
    }

    public void BuildL(Mpo mpo, int n) {
        for (int i = 0; i < this.A[n][0].GetSize()[1]; ++i) {
            this.L[n][i] = new Matrix(mpo.W[n][0][0].GetSize()[1], this.A[n][0].GetSize()[1]);
            for (int j = 0; j < this.states; ++j) {
                for (int k = 0; k < this.states; ++k) {
                    for (int i2 = 0; i2 < this.A[n][0].GetSize()[0]; ++i2) {
                        this.L[n][i] = n == 0 ? new Matrix(this.L[n][i].add(mpo.W[n][j][k].trans().mult(this.A[n][k]).mult(this.A[n][j].GetContent(i, 0)).trans())) : new Matrix(this.L[n][i].add(this.L[n - 1][i2].mult(mpo.W[n][j][k]).trans().mult(this.A[n][k]).mult(this.A[n][j].GetContent(i, i2)).trans()));
                    }
                }
            }
        }
    }

    public void waitKB() {
        try {
            while (System.in.read() != 99) {
                Thread.sleep(100L);
            }
        }
        catch (IOException iOException) {
            System.out.println("Fehler beim Schreiben der Datei");
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Fehler beim Schreiben der Datei");
        }
    }

    public void printState() {
        int n = 0;
        while ((double)n < Math.pow(this.states, this.N)) {
            Matrix matrix = new Matrix(this.A[0][n % this.states]);
            System.out.print("State " + n % this.states + " ");
            for (int i = 1; i < this.N; ++i) {
                System.out.print(n / (int)Math.pow(this.states, i) % this.states + " ");
                matrix = new Matrix(matrix.mult(this.A[i][n / (int)Math.pow(this.states, i) % this.states]));
            }
            System.out.println("");
            matrix.printreadable();
            ++n;
        }
    }
}

