/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.util.Range;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class LabelFormatterNumber
extends ALabelFormatter
implements IAxisLabelFormatter {
    private double m_cachedMinValueShift = Double.MAX_VALUE;
    protected NumberFormat m_numberFormat;

    public LabelFormatterNumber() {
        this.m_numberFormat = new DecimalFormat();
    }

    public LabelFormatterNumber(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Argument numberFormat must not be null.");
        }
        this.setNumberFormat(numberFormat);
    }

    public String format(double value) {
        return this.m_numberFormat.format(value);
    }

    public int getMaxAmountChars() {
        int fractionDigits = 0;
        Range range = this.getAxis().getRange();
        double dRange = range.getExtent();
        if (dRange < 1.0) {
            if (dRange == 0.0) {
                fractionDigits = 1;
            } else if (dRange == 0.0) {
                fractionDigits = 1;
            } else {
                while (dRange < 1.0) {
                    dRange *= 10.0;
                    ++fractionDigits;
                }
            }
        } else {
            fractionDigits = dRange < 10.0 ? 2 : (dRange < 100.0 ? 1 : 0);
        }
        int integerDigits = 0;
        double max = range.getMax();
        double min = Math.abs(range.getMin());
        if (max == 0.0 && min == 0.0) {
            integerDigits = 1;
        } else if (max < min) {
            while (min > 1.0) {
                min /= 10.0;
                ++integerDigits;
            }
        } else {
            while (max > 1.0) {
                max /= 10.0;
                ++integerDigits;
            }
        }
        if (integerDigits > this.m_numberFormat.getMaximumIntegerDigits()) {
            this.m_numberFormat.setMaximumIntegerDigits(integerDigits);
        }
        if (fractionDigits > this.m_numberFormat.getMaximumFractionDigits()) {
            this.m_numberFormat.setMaximumFractionDigits(fractionDigits);
        }
        int minFractionDigits = this.m_numberFormat.getMinimumFractionDigits();
        int minIntegerDigits = this.m_numberFormat.getMinimumIntegerDigits();
        if (minFractionDigits > fractionDigits) {
            fractionDigits = minFractionDigits;
        }
        if (minIntegerDigits > integerDigits) {
            integerDigits = minFractionDigits;
        }
        int result = 1 + integerDigits + 1 + fractionDigits;
        return result;
    }

    public double getMinimumValueShiftForChange() {
        if (this.m_cachedMinValueShift == Double.MAX_VALUE) {
            int fractionDigits = this.m_numberFormat.getMaximumFractionDigits();
            this.m_cachedMinValueShift = 1.0 / Math.pow(10.0, fractionDigits);
        }
        return this.m_cachedMinValueShift;
    }

    public double getNextEvenValue(double value, boolean ceiling) {
        double divisor = Math.pow(10.0, this.m_numberFormat.getMaximumFractionDigits());
        double result = ceiling ? Math.ceil(value * divisor) / divisor : Math.floor(value * divisor) / divisor;
        return result;
    }

    NumberFormat getNumberFormat() {
        return this.m_numberFormat;
    }

    public Number parse(String formatted) throws NumberFormatException {
        try {
            return this.m_numberFormat.parse(formatted);
        }
        catch (ParseException pe) {
            throw new NumberFormatException(pe.getMessage());
        }
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        NumberFormat old = this.m_numberFormat;
        this.m_numberFormat = numberFormat;
        this.m_propertyChangeSupport.firePropertyChange("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", old, this.m_numberFormat);
    }
}

