package dmrgvisu2;

public class MatrixMatrix
{
	private static final long serialVersionUID = 1L;
	int [] Size;		// 0: x, 1: y
	Matrix[][] Content;

	public int[] GetSize()
	{
		return this.Size;
	}
	public Matrix[][] GetContent()
	{
		return this.Content;
	}

	public MatrixMatrix()
	{
		this.SetSize(1,1);
	}
	public MatrixMatrix(int[] Size)
	{
		this.SetSize(Size);
	}
	public MatrixMatrix(int x, int y)
	{
		this.SetSize(x,y);
	}
	public MatrixMatrix(MatrixMatrix NewMatrix)
	{
		this.Size = NewMatrix.GetSize();
		this.Content = NewMatrix.GetContent();
	}
	private void CreateContent()
	{
		this.Content = new Matrix[this.Size[0]][this.Size[1]];
		for (int y = 0; y < this.Size[0]; y++)
			for (int x = 0; x < this.Size[1]; x++)
				this.Content[y][x] = new Matrix();
	}
	public void SetContent(int x, int y, Matrix Value)
	{
		this.Content[y][x] = Value;
	}
	public Matrix GetContent(int x, int y)
	{
		return this.Content[y][x];
	}
	public void SetContent(Matrix[][] Content)
	{
		this.SetSize(Content[0].length, Content.length);
		this.Content = Content;
	}
	public void SetSize(int x, int y)
	{
		int[] newSize = new int[2];
		newSize[0] = y;
		newSize[1] = x;
		this.SetSize(newSize);
	}
	public void SetSize(int[] Size)
	{
		this.Size = Size;
		this.CreateContent();
	}

	public String toString()
	{
		String newString = "This Matrix has the size: " + this.Size[1] + " by " + this.Size[0];
		newString = newString + "\n";
		for (int y = 0; y < this.Size[0]; y++)
		{
			for (int x = 0; x < this.Size[1]; x++)
			{
				newString = newString + " " + (this.Content[y][x].toString());
			}
			newString = newString + "\n";
		}
		return newString;

	}
	public MatrixMatrix mult(MatrixMatrix b)
	{
		MatrixMatrix newMatrix = new MatrixMatrix(b.GetSize()[1], this.GetSize()[0]);
		for (int i=0; i<newMatrix.GetSize()[0]; i++)
		{	
			for (int j=0; j<newMatrix.GetSize()[1]; j++)
			{
				newMatrix.SetContent(j,i, this.GetContent(0,i).mult(b.GetContent(j,0)));
				for (int k=1; k<this.GetSize()[1]; k++)
					newMatrix.SetContent(j,i, newMatrix.GetContent(j,i).add(this.GetContent(j,i).mult(b.GetContent(j,k))));
			}
		}
		return newMatrix;
	}
	public MatrixMatrix add(MatrixMatrix b)
	{
		MatrixMatrix newMatrix = new MatrixMatrix(b.GetSize()[1], this.GetSize()[0]);
		for (int i=0; i<newMatrix.GetSize()[0]; i++)
			for (int j=0; j<newMatrix.GetSize()[1]; j++)
				newMatrix.SetContent(j, i, this.GetContent(j,i).add(b.GetContent(j,i)));
		return newMatrix;
	}
}

